package com.ejie.aa17a.utilidades;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import org.springframework.context.i18n.LocaleContextHolder;

/**
 * 
 * @author francisco.galvez
 * 
 */
public class Aa17aFuncionesComunes {

	/**
	 * Constructor Aa17aFuncionesComunes
	 */
	private Aa17aFuncionesComunes() {
	}

	/**
	 * Función que devuelve una fecha compuesta por el día, mes, año de la fecha
	 * pasada como parámetro y la hora 23:59:59. Esta función se usa para
	 * filtros hasta en pantallas de búsqueda
	 * 
	 * 
	 * @param fecha
	 *            Date
	 * @return Date-. Fecha cuya hora será 23:59:59
	 */
	public static Date getDateHora(Date fecha) {
		Calendar calendario = Calendar.getInstance();
		calendario.setTime(fecha);
		calendario.set(Calendar.HOUR_OF_DAY, Aa17aConstantes.FORMATO_HORA_23);
		calendario.set(Calendar.MINUTE, Aa17aConstantes.FORMATO_MINUTO_59);
		calendario.set(Calendar.SECOND, Aa17aConstantes.FORMATO_SEGUNDO_59);
		return calendario.getTime();
	}

	/**
	 * Función que a partir de un Date devuelve una fecha formateada en el
	 * idioma que recibe como locale. Si el Date == null devuelve "".
	 * 
	 * @param fecha
	 *            Date
	 * @param locale
	 *            Locale
	 * @return String fecha formateada.
	 */
	public static String formatearFecha(Date fecha, Locale locale) {
		if (fecha == null) {
			return "";
		}
		//Locale locale = LocaleContextHolder.getLocale();
		String formato = Aa17aConstantes.FORMATO_FECHA_ES;// formato
															// castellano

		if (com.ejie.x38.util.Constants.EUSKARA.equals(locale.getLanguage())) {
			formato = Aa17aConstantes.FORMATO_FECHA_EU;
		}
		SimpleDateFormat formatoFecha = new SimpleDateFormat(formato, locale);
		return formatoFecha.format(fecha);
	}

	/**
	 * Función que a partir de un Date devuelve una fecha formateada en el
	 * idioma que recibe como locale. Si el Date == null devuelve "".
	 * 
	 * @param fecha
	 *            Date
	 * @return String fecha formateada.
	 */
	public static String formatearFecha(Date fecha) {
		if (fecha == null) {
			return "";
		}
		Locale locale = LocaleContextHolder.getLocale();
		String formato = Aa17aConstantes.FORMATO_FECHA_ES;// formato
															// castellano

		if (com.ejie.x38.util.Constants.EUSKARA.equals(locale.getLanguage())) {
			formato = Aa17aConstantes.FORMATO_FECHA_EU;
		}
		SimpleDateFormat formatoFecha = new SimpleDateFormat(formato, locale);
		return formatoFecha.format(fecha);
	}

	/**
	 * Función que a partir de un Date devuelve una fecha + hora formateada en
	 * el idioma que recibe como locale. Si el Date == null devuelve "".
	 * 
	 * La primera hora serian las 00:00
	 * 
	 * @param fecha
	 *            Date
	 * @param locale
	 *            Locale
	 * @return String fecha formateada.
	 */
	public static String formatearFechaHora(Date fecha, Locale locale) {
		if (fecha == null) {
			return "";
		}
		//Locale locale = LocaleContextHolder.getLocale();
		String formato = Aa17aConstantes.FORMATO_FECHA_HORA_ES;// formato
																// castellano

		if (com.ejie.x38.util.Constants.EUSKARA.equals(locale.getLanguage())) {
			formato = Aa17aConstantes.FORMATO_FECHA_HORA_EU;
		}
		SimpleDateFormat formatoFecha = new SimpleDateFormat(formato, locale);
		return formatoFecha.format(fecha);
	}

	/**
	 * Función que a partir de un Date devuelve una fecha + hora formateada en
	 * el idioma que recibe como locale. Si el Date == null devuelve "".
	 * 
	 * La primera hora serían las 24:00
	 * 
	 * @param fecha
	 *            Date
	 * @param locale
	 *            Locale
	 * @return String fecha formateada.
	 */
	public static String formatearFechaHora24(Date fecha, Locale locale) {
		if (fecha == null) {
			return "";
		}
		//Locale locale = LocaleContextHolder.getLocale();
		String formato = Aa17aConstantes.FORMATO_FECHA_HORA_24_ES;// formato
																	// castellano

		if (com.ejie.x38.util.Constants.EUSKARA.equals(locale.getLanguage())) {
			formato = Aa17aConstantes.FORMATO_FECHA_HORA_24_EU;
		}
		SimpleDateFormat formatoFecha = new SimpleDateFormat(formato, locale);
		return formatoFecha.format(fecha);
	}

	/**
	 * Formatea un BigDecimal en base al formato enviado en el parámetro
	 * DecimalFormat. En caso de que el valor sea nulo, devuelve vacio
	 * 
	 * @param valor
	 *            BigDecimal
	 * @param format
	 *            DecimalFormat
	 * @return String
	 */
	public static String formatearBigDecimal(BigDecimal valor, DecimalFormat format) {
		String retorno = "";
		if (valor != null) {
			retorno = format.format(valor);
		}
		return retorno;
	}

}